# SPDX-FileCopyrightText: 2026 Blender Authors
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# Generated by datamodel-codegen:
#   source filename:  blender_asset_library_openapi.yaml

from __future__ import annotations

from dataclasses import dataclass


@dataclass
class Contact:
    name: str
    url: str | None = None
    email: str | None = None


@dataclass
class AssetLibraryMeta:
    api_versions: dict[str, str]
    name: str
    contact: Contact


# This OpenAPI specification was used to generate the above code.
# It is here so that Blender does not have to parse the YAML file.
OPENAPI_SPEC = {
    'openapi': '3.0.0',
    'info': {
        'version': '1.0.0',
        'title': 'Blender Asset Library API',
        'description': "Blender's API for describing and fetching assets from online libraries.",
        'contact': {
            'name': 'Blender',
            'url': 'https://www.blender.org/'},
        'license': {
            'name': 'GPLv3',
            'url': 'https://www.gnu.org/licenses/gpl-3.0.en.html'}},
    'servers': [
        {
            'url': '/'}],
    'paths': {
        '/_asset-library-meta.json': {
            'summary': 'Meta-information about this asset library.',
            'get': {
                'summary': 'Retrieve the asset library meta info.',
                'operationId': 'getLibraryMeta',
                'responses': {
                    '200': {
                        'description': 'normal response',
                        'content': {
                            'application/json': {
                                'schema': {
                                    '$ref': '#/components/schemas/AssetLibraryMeta'}}}}}}}},
    'components': {
        'schemas': {
            'AssetLibraryMeta': {
                'type': 'object',
                'description': 'Meta-data of this asset library.',
                'properties': {
                    'api_versions': {
                        'type': 'object',
                        'description': 'API versions of this asset library. This is reflected in the URLs of all OpenAPI operations except the one to get this metadata.\nA single asset library can expose multiple versions, in order to be backward-compatible with older versions of Blender.\nProperties should be "v1", "v2", etc. and their values should point to their respective index files.\n',
                        'additionalProperties': {
                            'type': 'string'},
                        'patternProperties': {
                            '^v[0-9]+$': {
                                'type': 'string'}}},
                    'name': {
                        'type': 'string',
                        'description': 'Name of this asset library.'},
                    'contact': {
                        '$ref': '#/components/schemas/Contact'}},
                'required': [
                    'api_versions',
                    'name',
                    'contact'],
                'example': {
                    'api_versions': {
                        'v1': '_v1/asset-index.json'},
                    'name': 'Blender Essentials',
                    'contact': {
                        'name': 'Blender',
                        'url': 'https://www.blender.org/'}}},
            'Contact': {
                'type': 'object',
                'description': 'Owner / publisher of this asset library.',
                'properties': {
                    'name': {
                        'type': 'string'},
                    'url': {
                        'type': 'string'},
                    'email': {
                        'type': 'string'}},
                'required': ['name']}}}}
